<?php
// Include database configuration
require_once __DIR__ . '/db_config.php';

// Attempt to connect to MySQL database
$mysqli = new mysqli(DB_HOST, DB_USERNAME, DB_PASSWORD, DB_NAME);

// Check connection
if ($mysqli->connect_error) {
    // Log error to a file or error tracking system in a real application
    // For development, we can output the error, but this should be disabled in production.
    error_log("Database Connection Failed: " . $mysqli->connect_error);
    die("Sorry, we're experiencing some technical difficulties. Please try again later."); // User-friendly message
}

// Set character set to utf8mb4 (recommended for full Unicode support)
if (!$mysqli->set_charset("utf8mb4")) {
    error_log("Error loading character set utf8mb4: " . $mysqli->error);
    // Continue execution as this might not be critical for all setups, but log it.
}

// The $mysqli object is now available for use in other scripts that include this file.
?>
