<?php
// Include Composer's autoloader
require_once __DIR__ . '/../vendor/autoload.php'; // Adjust path if your vendor dir is elsewhere

// Include your configuration for API keys
require_once __DIR__ . '/db_config.php';

// Initialize Stripe API client
// The library will automatically use the API key set here for all calls
try {
    \Stripe\Stripe::setApiKey(STRIPE_SECRET_KEY);
} catch (\Stripe\Exception\AuthenticationException $e) {
    // Handle authentication error with Stripe (e.g., invalid API key)
    // Log this error and show a generic error message to the user or die gracefully
    error_log('Stripe API Key Authentication Error: ' . $e->getMessage());
    // Depending on where this is included, you might not want to die here directly
    // but rather allow the calling script to handle it.
    // For scripts directly involved in payment processing, dying might be appropriate.
    if (basename($_SERVER['PHP_SELF']) === 'create_checkout_session.php' || basename($_SERVER['PHP_SELF']) === 'payment_success.php') {
        die('Payment system configuration error. Please notify support.');
    }
    // For other pages, maybe just log and continue if Stripe isn't critical for that page load.
}

// You can also set other global Stripe configurations if needed, e.g.,
// \Stripe\Stripe::setApiVersion("2020-08-27"); // Example specific API version

// The Stripe client is now configured for use in other scripts.

// Log for debugging
error_log("Stripe init loaded successfully");
error_log("STRIPE_LIFETIME_PLAN_PRICE_ID: " . (defined('STRIPE_LIFETIME_PLAN_PRICE_ID') ? STRIPE_LIFETIME_PLAN_PRICE_ID : 'NOT DEFINED'));
error_log("STRIPE_MONTHLY_PLAN_PRICE_ID: " . (defined('STRIPE_MONTHLY_PLAN_PRICE_ID') ? STRIPE_MONTHLY_PLAN_PRICE_ID : 'NOT DEFINED'));
error_log("STRIPE_YEARLY_PLAN_PRICE_ID: " . (defined('STRIPE_YEARLY_PLAN_PRICE_ID') ? STRIPE_YEARLY_PLAN_PRICE_ID : 'NOT DEFINED'));
?>
