<?php
// public/home.php
// This page will be the main landing page for non-logged-in users,
// featuring the ADA compliance checker.

// Session start is handled in header.php
require_once __DIR__ . '/../includes/header.php';
?>

<!-- Hero Section -->
<section class="hero-section">
    <div class="hero-container">
        <div class="hero-content">
            <h1 class="hero-title">Make Your Website Accessible to All – ADA Compliance Starts Here</h1>
            <p class="hero-subtitle">Ensure Equal Access for Everyone. Avoid Legal Risk. Enhance Your Business Reputation.</p>
            
            <div class="hero-cta">
                <div class="ada-checker-input-group">
                    <input type="url" id="websiteUrlToCheck" placeholder="https://yourwebsite.com" aria-label="Website URL to check">
                    <button id="checkComplianceButton" class="button primary">Check My Website</button>
                </div>
                <p class="hero-note">Free ADA compliance check • Takes under 30 seconds</p>
            </div>
        </div>
        
        <div class="hero-visual">
            <div class="hero-image-container">
                <img src="images/ADA Compliace USA.png" alt="ADA Website Compliance - Making websites accessible for all Americans" class="hero-ada-image">
            </div>
            
            <div class="accessibility-icons">
                <div class="icon-item">
                    <svg width="60" height="60" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M9 12l2 2 4-4"/>
                        <circle cx="12" cy="12" r="9"/>
                    </svg>
                    <span>Compliant</span>
                </div>
                <div class="icon-item">
                    <svg width="60" height="60" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"/>
                        <circle cx="12" cy="12" r="3"/>
                    </svg>
                    <span>Accessible</span>
                </div>
                <div class="icon-item">
                    <svg width="60" height="60" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M9 11H1l6-6v4a8 8 0 0 1 8 8"/>
                        <path d="M15 13h8l-6 6v-4a8 8 0 0 1-8-8"/>
                    </svg>
                    <span>Protected</span>
                </div>
            </div>
        </div>
    </div>
    
    <div id="complianceResult" class="compliance-result-container">
        <!-- This will be populated by JavaScript -->
    </div>

    <!-- Compliance Check Modal -->
    <div id="complianceModal" class="compliance-modal">
        <div class="modal-overlay"></div>
        <div class="modal-content">
            <button class="modal-close" onclick="closeComplianceModal()">&times;</button>
            
            <!-- Loading State -->
            <div id="loadingState" class="modal-state">
                <div class="loading-spinner"></div>
                <h3>Checking Your Website...</h3>
                <p>Please wait while we analyze your website's ADA compliance.</p>
            </div>
            
            <!-- Compliant State -->
            <div id="compliantState" class="modal-state" style="display: none;">
                <div class="status-icon success">
                    <svg width="80" height="80" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M9 12l2 2 4-4"/>
                        <circle cx="12" cy="12" r="9"/>
                    </svg>
                </div>
                <h3>Congratulations!</h3>
                <p class="status-message">Your website is ADA Compliant</p>
                <p class="status-description">Our analysis shows that your website has proper accessibility features in place. Keep up the great work!</p>
                <div class="modal-actions">
                    <button class="button primary" onclick="window.location.href='dashboard.php'">Manage you plan</button>
                    <button class="button secondary" onclick="closeComplianceModal()">Close</button>
                </div>
            </div>
            
            <!-- Non-Compliant State -->
            <div id="nonCompliantState" class="modal-state" style="display: none;">
                <div class="status-icon danger">
                    <svg width="80" height="80" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <line x1="18" y1="6" x2="6" y2="18"></line>
                        <line x1="6" y1="6" x2="18" y2="18"></line>
                        <circle cx="12" cy="12" r="9"/>
                    </svg>
                </div>
                <h3>Your Website is NOT ADA Compliant</h3>
                <p class="status-message danger-text">Critical Accessibility Issues Found</p>
                
                <div class="urgency-message">
                    <h4>🚨 Don't Wait - Act Now!</h4>
                    <p>Every day your website remains non-compliant increases your risk. Protect your business today!</p>
                </div>
                
                <div class="modal-actions">
                    <button class="button primary large pulse" onclick="window.location.href='register.php'">
                        Get ADA Compliant Now - Starting $19.99/month
                    </button>
                    <button class="button secondary" onclick="closeComplianceModal()">I'll Risk It (Not Recommended)</button>
                </div>
            </div>
            
            <!-- Error State -->
            <div id="errorState" class="modal-state" style="display: none;">
                <div class="status-icon warning">
                    <svg width="80" height="80" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <circle cx="12" cy="12" r="10"/>
                        <line x1="12" y1="8" x2="12" y2="12"/>
                        <line x1="12" y1="16" x2="12.01" y2="16"/>
                    </svg>
                </div>
                <h3>Unable to Check Website</h3>
                <p class="status-message">We couldn't analyze your website at this time.</p>
                <p class="status-description">Please check the URL and try again, or contact our support team for assistance.</p>
                <div class="modal-actions">
                    <button class="button primary" onclick="closeComplianceModal()">Try Again</button>
                    <button class="button secondary" onclick="window.location.href='register.php'">Get Help from Our Team</button>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Stats Section -->
<section class="stats-section">
    <div class="container">
        <div class="stats-grid">
            <div class="stat-item">
                <div class="stat-number">88%</div>
                <div class="stat-label">of websites are NOT ADA compliant</div>
            </div>
            <div class="stat-item">
                <div class="stat-number">800%</div>
                <div class="stat-label">more lawsuites than in 2024</div>
            </div>
            <div class="stat-item">
                <div class="stat-number">61M</div>
                <div class="stat-label">Americans with disabilities</div>
            </div>
            <div class="stat-item">
                <div class="stat-number">20%</div>
                <div class="stat-label">of potential customers you could be missing</div>
            </div>
        </div>
    </div>
</section>

<!-- Importance Section -->
<section class="importance-section">
    <div class="container">
        <div class="section-header">
            <h2>The Importance of ADA Compliance</h2>
            <p class="section-subtitle">In today's digital world, accessibility isn't just a legal obligation—it's a fundamental right.</p>
        </div>
        
        <div class="content-grid">
            <div class="content-text">
                <p>The Americans with Disabilities Act (ADA) mandates that all public websites be accessible to people with disabilities. Unfortunately, most websites today fail to meet ADA standards, leaving businesses vulnerable to lawsuits, financial penalties, and reputational damage.</p>
                
                <div class="highlight-box">
                    <h3>Is your website ADA compliant?</h3>
                    <p>If you're unsure, you're not alone. Over 88% of websites today are not ADA-compliant, and many face lawsuits as a result. <strong>Don't risk your business's future—take control of your digital accessibility today.</strong></p>
                </div>
            </div>
            
            <div class="risk-indicators">
                <div class="risk-item danger">
                    <div class="risk-icon">⚠️</div>
                    <div class="risk-content">
                        <h4>Legal Risk</h4>
                        <p>Low hanging fruit for any lawyer.  Don't be an easy target.</p>
                    </div>
                </div>
                <div class="risk-item warning">
                    <div class="risk-icon">💰</div>
                    <div class="risk-content">
                        <h4>Financial Impact</h4>
                        <p>Average settlement: $5,000 - $75,000</p>
                    </div>
                </div>
                <div class="risk-item info">
                    <div class="risk-icon">📈</div>
                    <div class="risk-content">
                        <h4>Lost Revenue</h4>
                        <p>Missing 20% of potential customers</p>
                        <p>(leaving the money on the table)</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Why ADA Compliance Matters -->
<section class="benefits-section">
    <div class="container">
        <h2>Why ADA Compliance Matters</h2>
        
        <!-- Add the ADA Law Image -->
        <div class="ada-law-image-container">
            <img src="images/ADA Compliance- It is the law.png" alt="ADA Compliance for Websites - It's the Law" class="ada-law-image">
        </div>
        
        <div class="benefits-grid">
            <div class="benefit-card">
                <div class="benefit-icon">
                    <svg width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M9 12l2 2 4-4"/>
                        <path d="M21 12c-1 0-3-1-3-3s2-3 3-3 3 1 3 3-2 3-3 3"/>
                        <path d="M3 12c1 0 3-1 3-3s-2-3-3-3-3 1-3 3 2 3 3 3"/>
                        <path d="M13 12h1"/>
                    </svg>
                </div>
                <h3>Avoid Lawsuits & Penalties</h3>
                <p>ADA violations are low-hanging fruit for lawyers targeting non-compliant websites. Without action, your business could be the next target. A single lawsuit can cost thousands in legal fees, settlements, and penalties.</p>
            </div>
            
            <div class="benefit-card">
                <div class="benefit-icon">
                    <svg width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"/>
                        <circle cx="9" cy="7" r="4"/>
                        <path d="M23 21v-2a4 4 0 0 0-3-3.87"/>
                        <path d="M16 3.13a4 4 0 0 1 0 7.75"/>
                    </svg>
                </div>
                <h3>Increase Customer Reach</h3>
                <p>An accessible website isn't just about legal protection. It's about reaching more customers, including the estimated 20% of Americans who have disabilities. ADA-compliant websites show that your business is committed to inclusivity and equal access.</p>
            </div>
            
            <div class="benefit-card">
                <div class="benefit-icon">
                    <svg width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z"/>
                    </svg>
                </div>
                <h3>Boost Your Reputation</h3>
                <p>In today's socially-conscious marketplace, showing that your business cares about disability rights can set you apart. Being ADA compliant means demonstrating your commitment to fairness and accessibility, making you more trustworthy in the eyes of consumers and clients.</p>
            </div>
        </div>
    </div>
</section>

<!-- How We Help Section -->
<section id="how-we-help" class="solutions-section">
    <div class="container">
        <div class="section-header">
            <h2>How We Can Help</h2>
            <p class="section-subtitle">We specialize in simple, affordable, and effective solutions to get your website ADA compliant—fast.</p>
        </div>
        
        <div class="solutions-grid">
            <div class="solution-card">
                <div class="solution-number">1</div>
                <h3>Free ADA Website Audit</h3>
                <p>Run a quick, comprehensive check to identify accessibility barriers on your website. Our easy-to-use tool will show you exactly where you need to improve.</p>
                <div class="solution-features">
                    <span class="feature-tag">✓ Instant Results</span>
                    <span class="feature-tag">✓ No Registration Required</span>
                </div>
            </div>
            
            <div class="solution-card">
                <div class="solution-number">2</div>
                <h3>Tailored ADA Solutions</h3>
                <p>Our team will help you fix your website's accessibility issues with disruption. From improving navigation to adding alt text to images, we'll ensure your site is compliant with ADA standards.</p>
                <div class="solution-features">
                    <span class="feature-tag">✓ Custom Implementation</span>
                    <span class="feature-tag">✓ No Disruption</span>
                    <span class="feature-tag">✓ Expert Support</span>
                </div>
            </div>
            
            <div class="solution-card highlighted">
                <div class="solution-number">3</div>
                <h3>Affordable Pricing</h3>
                <p>Why pay hundreds of dollars to other services? Our solutions are designed to provide maximum value at a competitive price. Starting at just $19.99/month, we offer a cost-effective way to protect your business and enhance your reputation.</p>
                <div class="pricing-highlight">
                    <div class="price">$19.99<span>/month</span></div>
                    <div class="price-note">Or $399 lifetime</div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Testimonials Section -->
<section class="testimonials-section">
    <div class="container">
        <h2>What Our Customers Say</h2>
        
        <div class="testimonials-grid">
            <div class="testimonial-card">
                <div class="testimonial-content">
                    <p>"I didn't realize how much I was at risk until I found this service. The audit was quick, and the fixes were easy to implement. Now I know my website is ADA compliant, and I'm confident I'm not at risk for a lawsuit!"</p>
                </div>
                <div class="testimonial-author">
                    <div class="author-info">
                        <strong>John D.</strong>
                        <span>Small Business Owner</span>
                    </div>
                    <div class="testimonial-rating">
                        ⭐⭐⭐⭐⭐
                    </div>
                </div>
            </div>
            
            <div class="testimonial-card">
                <div class="testimonial-content">
                    <p>"This tool saved us time and money. It was easy to understand, and the process was straightforward. We're now compliant and can focus on serving our customers."</p>
                </div>
                <div class="testimonial-author">
                    <div class="author-info">
                        <strong>Sarah L.</strong>
                        <span>E-commerce Entrepreneur</span>
                    </div>
                    <div class="testimonial-rating">
                        ⭐⭐⭐⭐⭐
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Final CTA Section -->
<section class="final-cta-section">
    <div class="container">
        <div class="cta-content">
            <h2>Ready to Make Your Website Accessible?</h2>
            <p>Don't wait until it's too late. Start today by checking if your website is ADA compliant with our free audit tool. If there are issues, we'll provide you with a simple plan to fix them—fast and affordably.</p>
            
            <div class="cta-actions">
                <button class="button primary large" onclick="document.getElementById('websiteUrlToCheck').focus()">
                    Start Your Free Audit Now
                </button>
                <p class="cta-note">Get your compliance report in under 30 seconds • No credit card required</p>
            </div>
            
            <div class="trust-indicators">
                <div class="trust-item">
                    <span class="trust-icon">🔒</span>
                    <span>Secure & Private</span>
                </div>
                <div class="trust-item">
                    <span class="trust-icon">⚡</span>
                    <span>Instant Results</span>
                </div>
                <div class="trust-item">
                    <span class="trust-icon">💯</span>
                    <span>100% Free Audit</span>
                </div>
            </div>
        </div>
    </div>
</section>

<style>
/* Hero Section */
.hero-section {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 80px 0 40px;
    min-height: 600px;
    display: flex;
    align-items: center;
    flex-direction: column;
}

.hero-container {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 60px;
    max-width: 1200px;
    margin: 0 auto;
    padding: 0 20px;
    align-items: center;
}

.hero-title {
    font-size: 3.5em;
    font-weight: 700;
    line-height: 1.2;
    margin-bottom: 20px;
}

.hero-subtitle {
    font-size: 1.3em;
    margin-bottom: 40px;
    opacity: 0.9;
    line-height: 1.4;
}

.ada-checker-input-group {
    display: flex;
    gap: 15px;
    margin-bottom: 15px;
    max-width: 500px;
}

.ada-checker-input-group input {
    flex: 1;
    padding: 15px 20px;
    border: none;
    border-radius: 8px;
    font-size: 1.1em;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
}

.ada-checker-input-group .button {
    padding: 15px 30px;
    font-size: 1.1em;
    font-weight: 600;
    white-space: nowrap;
    border-radius: 8px;
    border: none;
    cursor: pointer;
}

.button.primary {
    background: #27ae60;
    color: white;
    transition: background 0.3s ease;
}

.button.primary:hover {
    background: #229954;
}

.button.secondary {
    background: #ff6666;
    color: white;
    border: 2px solid white;
}

.button.secondary:hover {
    background: white;
    color: #667eea;
}

.button.large {
    padding: 20px 40px;
    font-size: 1.2em;
}

.hero-note {
    font-size: 0.9em;
    opacity: 0.8;
    margin: 0;
}

.hero-image-container {
    margin-bottom: 30px;
    text-align: center;
}

.hero-ada-image {
    width: 100%;
    max-width: 400px;
    height: auto;
    border-radius: 15px;
    box-shadow: 0 10px 30px rgba(0,0,0,0.2);
    transition: transform 0.3s ease;
}

.hero-ada-image:hover {
    transform: scale(1.05);
}

/* Update the hero-visual styling */
.hero-visual {
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
}

.accessibility-icons {
    display: flex;
    justify-content: space-around;
    gap: 20px;
    width: 100%;
    max-width: 400px;
}

.icon-item {
    text-align: center;
    padding: 20px;
    background: rgba(255,255,255,0.1);
    border-radius: 15px;
    backdrop-filter: blur(10px);
}

.icon-item svg {
    color: #27ae60;
    margin-bottom: 10px;
}

.icon-item span {
    display: block;
    font-weight: 500;
}

/* Compliance Result Styling */
.compliance-result-container {
    max-width: 800px;
    margin: 40px auto 0;
    padding: 0 20px;
}

.installation-prompt {
    background: rgba(255,255,255,0.95);
    color: #2c3e50;
    padding: 40px;
    border-radius: 15px;
    text-align: center;
    margin: 40px auto 0;
    max-width: 600px;
    box-shadow: 0 10px 30px rgba(0,0,0,0.2);
}

.prompt-content h3 {
    color: #e74c3c;
    font-size: 1.8em;
    margin-bottom: 15px;
}

.prompt-actions {
    display: flex;
    gap: 15px;
    justify-content: center;
    flex-wrap: wrap;
    margin-top: 25px;
}

/* Stats Section */
.stats-section {
    background: #2c3e50;
    color: white;
    padding: 60px 0;
}

.container {
    max-width: 1200px;
    margin: 0 auto;
    padding: 0 20px;
}

.stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 40px;
    text-align: center;
}

.stat-number {
    font-size: 3em;
    font-weight: 700;
    color: #e74c3c;
    margin-bottom: 10px;
}

.stat-label {
    font-size: 1.1em;
    opacity: 0.9;
}

/* Importance Section */
.importance-section {
    padding: 80px 0;
    background: #f8f9fa;
}

.section-header {
    text-align: center;
    margin-bottom: 60px;
}

.section-header h2 {
    font-size: 2.5em;
    color: #2c3e50;
    margin-bottom: 20px;
}

.section-subtitle {
    font-size: 1.2em;
    color: #7f8c8d;
    max-width: 600px;
    margin: 0 auto;
}

.content-grid {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 60px;
    align-items: start;
}

.content-text p {
    font-size: 1.1em;
    line-height: 1.6;
    color: #2c3e50;
    margin-bottom: 30px;
}

.highlight-box {
    background: #fff3cd;
    border-left: 4px solid #ffc107;
    padding: 25px;
    border-radius: 8px;
}

.highlight-box h3 {
    color: #856404;
    margin-bottom: 15px;
}

.risk-indicators {
    display: flex;
    flex-direction: column;
    gap: 20px;
}

.risk-item {
    display: flex;
    align-items: center;
    gap: 20px;
    padding: 20px;
    border-radius: 10px;
    box-shadow: 0 3px 10px rgba(0,0,0,0.1);
}

.risk-item.danger { background: #f8d7da; border-left: 4px solid #dc3545; }
.risk-item.warning { background: #fff3cd; border-left: 4px solid #ffc107; }
.risk-item.info { background: #d1ecf1; border-left: 4px solid #17a2b8; }

.risk-icon {
    font-size: 2em;
}

.risk-content h4 {
    margin-bottom: 5px;
    color: #2c3e50;
}

/* Benefits Section */
.benefits-section {
    padding: 80px 0;
    background: white;
}

.benefits-section h2 {
    text-align: center;
    font-size: 2.5em;
    color: #2c3e50;
    margin-bottom: 60px;
}

/* ADA Law Image Styling */
.ada-law-image-container {
    text-align: center;
    margin-bottom: 50px;
}

.ada-law-image {
    width: 100%;
    max-width: 600px;
    height: auto;
    border-radius: 15px;
    box-shadow: 0 10px 30px rgba(0,0,0,0.15);
    transition: transform 0.3s ease;
}

.ada-law-image:hover {
    transform: scale(1.02);
}

.benefits-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    gap: 40px;
}

.benefit-card {
    text-align: center;
    padding: 40px 30px;
    border-radius: 15px;
    box-shadow: 0 5px 20px rgba(0,0,0,0.1);
    transition: transform 0.3s ease;
}

.benefit-card:hover {
    transform: translateY(-5px);
}

.benefit-icon {
    color: #3498db;
    margin-bottom: 20px;
}

.benefit-card h3 {
    color: #2c3e50;
    font-size: 1.5em;
    margin-bottom: 20px;
}

.benefit-card p {
    color: #7f8c8d;
    line-height: 1.6;
}

/* Solutions Section */
.solutions-section {
    padding: 80px 0;
    background: #f8f9fa;
}

.solutions-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(320px, 1fr));
    gap: 30px;
    margin-top: 60px;
}

.solution-card {
    background: white;
    padding: 40px 30px;
    border-radius: 15px;
    box-shadow: 0 5px 20px rgba(0,0,0,0.1);
    position: relative;
    transition: transform 0.3s ease;
}

.solution-card:hover {
    transform: translateY(-5px);
}

.solution-card.highlighted {
    border: 2px solid #27ae60;
    transform: scale(1.05);
}

.solution-number {
    position: absolute;
    top: -15px;
    left: 30px;
    background: #3498db;
    color: white;
    width: 30px;
    height: 30px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: bold;
}

.solution-card h3 {
    color: #2c3e50;
    font-size: 1.4em;
    margin: 20px 0 15px;
}

.solution-card p {
    color: #7f8c8d;
    line-height: 1.6;
    margin-bottom: 20px;
}

.solution-features {
    display: flex;
    flex-wrap: wrap;
    gap: 10px;
}

.feature-tag {
    background: #e8f5e8;
    color: #27ae60;
    padding: 5px 12px;
    border-radius: 20px;
    font-size: 0.9em;
    font-weight: 500;
}

.pricing-highlight {
    text-align: center;
    margin-top: 20px;
}

.price {
    font-size: 2.5em;
    font-weight: 700;
    color: #27ae60;
}

.price span {
    font-size: 0.5em;
    color: #7f8c8d;
}

.price-note {
    color: #7f8c8d;
    margin-top: 5px;
}

/* Testimonials Section */
.testimonials-section {
    padding: 80px 0;
    background: white;
}

.testimonials-section h2 {
    text-align: center;
    font-size: 2.5em;
    color: #2c3e50;
    margin-bottom: 60px;
}

.testimonials-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(400px, 1fr));
    gap: 40px;
}

.testimonial-card {
    background: #f8f9fa;
    padding: 30px;
    border-radius: 15px;
    border-left: 4px solid #3498db;
}

.testimonial-content p {
    font-style: italic;
    font-size: 1.1em;
    line-height: 1.6;
    color: #2c3e50;
    margin-bottom: 20px;
}

.testimonial-author {
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.author-info strong {
    display: block;
    color: #2c3e50;
}

.author-info span {
    color: #7f8c8d;
    font-size: 0.9em;
}

/* Final CTA Section */
.final-cta-section {
    background: linear-gradient(135deg, #2c3e50 0%, #34495e 100%);
    color: white;
    padding: 80px 0;
    text-align: center;
}

.cta-content h2 {
    font-size: 2.5em;
    margin-bottom: 20px;
}

.cta-content p {
    font-size: 1.2em;
    margin-bottom: 40px;
    opacity: 0.9;
    max-width: 800px;
    margin-left: auto;
    margin-right: auto;
}

.cta-actions {
    margin-bottom: 40px;
}

.cta-note {
    font-size: 0.9em;
    opacity: 0.8;
    margin-top: 15px;
}

.trust-indicators {
    display: flex;
    justify-content: center;
    gap: 40px;
    flex-wrap: wrap;
    margin-top: 40px;
}

.trust-item {
    display: flex;
    align-items: center;
    gap: 10px;
    font-size: 1.1em;
}

.trust-icon {
    font-size: 1.5em;
}

/* Compliance Modal Styles */
.compliance-modal {
    display: none;
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    z-index: 1000;
    animation: fadeIn 0.3s ease;
}

.modal-overlay {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0, 0, 0, 0.7);
    backdrop-filter: blur(5px);
}

.modal-content {
    position: relative;
    background: white;
    max-width: 600px;
    margin: 5% auto;
    border-radius: 20px;
    box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
    animation: slideIn 0.3s ease;
    max-height: 90vh;
    overflow-y: auto;
}

.modal-close {
    position: absolute;
    top: 20px;
    right: 25px;
    background: none;
    border: none;
    font-size: 30px;
    color: #999;
    cursor: pointer;
    z-index: 10;
    transition: color 0.3s ease;
}

.modal-close:hover {
    color: #e74c3c;
}

.modal-state {
    padding: 40px 40px 40px;
    text-align: center;
}

/* Status Icons */
.status-icon {
    margin: 0 auto 30px;
    width: 120px;
    height: 120px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    animation: bounceIn 0.6s ease;
}

.status-icon.success {
    background: linear-gradient(135deg, #27ae60, #2ecc71);
    color: white;
    box-shadow: 0 10px 30px rgba(39, 174, 96, 0.3);
}

.status-icon.danger {
    background: linear-gradient(135deg, #e74c3c, #c0392b);
    color: white;
    box-shadow: 0 10px 30px rgba(231, 76, 60, 0.3);
}

.status-icon.warning {
    background: linear-gradient(135deg, #f39c12, #e67e22);
    color: white;
    box-shadow: 0 10px 30px rgba(243, 156, 18, 0.3);
}

/* Loading Spinner */
.loading-spinner {
    width: 60px;
    height: 60px;
    border: 4px solid #f3f3f3;
    border-top: 4px solid #3498db;
    border-radius: 50%;
    animation: spin 1s linear infinite;
    margin: 0 auto 30px;
}

/* Modal Text */
.modal-state h3 {
    font-size: 1em;
    margin-bottom: 15px;
    color: #2c3e50;
}

.status-message {
    font-size: 1.3em;
    font-weight: 600;
    margin-bottom: 20px;
    color: #27ae60;
}

.status-message.danger-text {
    color: #e74c3c;
}

.status-description {
    font-size: 1.1em;
    color: #7f8c8d;
    line-height: 1.6;
    margin-bottom: 30px;
}

/* Danger Details */
.danger-details {
    background: #fdf2f2;
    border-radius: 10px;
    padding: 25px;
    margin: 25px 0;
    border-left: 4px solid #e74c3c;
}

.danger-item {
    display: flex;
    align-items: center;
    gap: 15px;
    margin-bottom: 15px;
    font-size: 1em;
    color: #2c3e50;
}

.danger-item:last-child {
    margin-bottom: 0;
}

.danger-icon {
    font-size: 1.5em;
    min-width: 30px;
}

/* Urgency Message */
.urgency-message {
    background: linear-gradient(135deg, #ff6b6b, #ee5a52);
    color: white;
    padding: 20px;
    border-radius: 10px;
    margin: 25px 0;
}

.urgency-message h4 {
    margin-bottom: 10px;
    font-size: 1.2em;
}

.urgency-message p {
    margin: 0;
    opacity: 0.9;
}

/* Modal Actions */
.modal-actions {
    display: flex;
    gap: 15px;
    justify-content: center;
    flex-wrap: wrap;
    margin-top: 30px;
}

.modal-actions .button {
    padding: 15px 25px;
    border-radius: 8px;
    font-weight: 600;
    text-decoration: none;
    border: none;
    cursor: pointer;
    transition: all 0.3s ease;
    min-width: 180px;
}

.modal-actions .button.large {
    padding: 18px 30px;
    font-size: 1.1em;
}

.modal-actions .button.pulse {
    animation: pulse 2s infinite;
}

/* Animations */
@keyframes fadeIn {
    from { opacity: 0; }
    to { opacity: 1; }
}

@keyframes slideIn {
    from {
        transform: translateY(-50px);
        opacity: 0;
    }
    to {
        transform: translateY(0);
        opacity: 1;
    }
}

@keyframes bounceIn {
    0% {
        transform: scale(0.3);
        opacity: 0;
    }
    50% {
        transform: scale(1.05);
    }
    70% {
        transform: scale(0.9);
    }
    100% {
        transform: scale(1);
        opacity: 1;
    }
}

@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

@keyframes pulse {
    0% {
        transform: scale(1);
        box-shadow: 0 0 0 0 rgba(39, 174, 96, 0.7);
    }
    70% {
        transform: scale(1.05);
        box-shadow: 0 0 0 10px rgba(39, 174, 96, 0);
    }
    100% {
        transform: scale(1);
        box-shadow: 0 0 0 0 rgba(39, 174, 96, 0);
    }
}

/* Responsive Design */
@media (max-width: 768px) {
    .hero-container {
        grid-template-columns: 1fr;
        gap: 40px;
        text-align: center;
    }
    
    .hero-title {
        font-size: 2.5em;
    }
    
    .ada-checker-input-group {
        flex-direction: column;
    }
    
    .accessibility-icons {
        flex-direction: column;
        gap: 15px;
        max-width: 250px;
    }
    
    .content-grid {
        grid-template-columns: 1fr;
        gap: 40px;
    }
    
    .stats-grid {
        grid-template-columns: repeat(2, 1fr);
        gap: 30px;
    }
    
    .benefits-grid,
    .solutions-grid,
    .testimonials-grid {
        grid-template-columns: 1fr;
    }
    
    .trust-indicators {
        flex-direction: column;
        gap: 20px;
    }
    
    .prompt-actions {
        flex-direction: column;
    }
    
    .solution-card.highlighted {
        transform: none;
    }
}

@media (max-width: 480px) {
    .hero-ada-image {
        max-width: 250px;
    }
    
    .ada-law-image {
        max-width: 350px;
    }
    
    .ada-law-image-container {
        margin-bottom: 30px;
    }
    
    .modal-content {
        margin: 10px;
        max-width: calc(100% - 20px);
    }
    
    .modal-state {
        padding: 40px 25px 25px;
    }
    
    .modal-state h3 {
        font-size: 1.6em;
    }
    
    .status-icon {
        width: 100px;
        height: 100px;
    }
    
    .modal-actions {
        flex-direction: column;
        align-items: center;
    }
    
    .modal-actions .button {
        width: 100%;
        max-width: 300px;
    }
    
    .danger-item {
        font-size: 0.9em;
    }
}
</style>

<?php
// Include the JavaScript for the checker
?>
<script src="js/ada-checker.js" defer></script>

<?php
require_once __DIR__ . '/../includes/footer.php';
?>
