<?php
// It's good practice to include auth_check if you want consistent header/footer,
// or if you might add user-specific messages later.
// If it's purely informational, auth_check might be optional but helps with nav.
require_once __DIR__ . '/../includes/auth_check.php';
require_once __DIR__ . '/../includes/header.php';

$page_title = "Payment Cancelled";
$message = "Your payment process was cancelled, or the payment could not be completed at this time. You have not been charged.";
$message_detail = "If you wish to try again, please return to your dashboard.";

// You could potentially retrieve more details from Stripe if a session ID was passed back,
// but typically for a cancel URL, it's simpler.
// For example, if Stripe appended ?session_id={CHECKOUT_SESSION_ID} here,
// you could log that session_id for internal tracking of abandoned checkouts.
// $stripe_checkout_session_id = $_GET['session_id'] ?? null;
// if ($stripe_checkout_session_id) {
//     error_log("User {$user_id} cancelled checkout session: {$stripe_checkout_session_id}");
// }

?>

<div class="payment-status-container">
    <h2><?php echo htmlspecialchars($page_title); ?></h2>

    <div class="errors">
        <p><?php echo htmlspecialchars($message); ?></p>
        <p><?php echo htmlspecialchars($message_detail); ?></p>
    </div>

    <p style="margin-top: 20px;">
        <a href="dashboard.php" class="button">Return to Dashboard</a>
    </p>
</div>

<?php
// No database connection typically needed here unless logging abandonment in DB.
require_once __DIR__ . '/../includes/footer.php';
?>
