<?php
require_once __DIR__ . '/../includes/header.php';
?>

<div class="terms-container">
    <div class="terms-content">
        <h1>Terms of Service</h1>
        <p class="effective-date"><strong>Effective Date: July 1, 2025</strong></p>

        <p>These Terms of Service ("Terms") govern your use of the website ("Your Website") and the services provided by Ranzo Tech LLC ("we," "our," or "us"). By accessing or using the Website and services, you agree to these Terms.</p>

        <section class="terms-section">
            <h2>1. Use of Our Services</h2>
            <p>By using our ADA compliance services, including our website audit tool, snippet generator, and consultation services, you agree to comply with these Terms and all applicable laws.</p>
            
            <ul>
                <li><strong>Eligibility:</strong> You must be at least 18 years old and have the legal capacity to enter into these Terms.</li>
                <li><strong>Account Registration:</strong> To access certain features, you may need to create an account. You agree to provide accurate and complete information during the registration process.</li>
            </ul>
        </section>

        <section class="terms-section">
            <h2>2. Services Provided</h2>
            <p>We provide a platform to help businesses assess and correct their ADA website compliance. This includes:</p>
            
            <ul>
                <li>ADA website audits to identify accessibility issues.</li>
                <li>Snippet generation for ADA-compliant widgets.</li>
                <li>Consultation and resources to help businesses achieve compliance with the Americans with Disabilities Act.</li>
            </ul>
        </section>

        <section class="terms-section">
            <h2>3. Payment and Subscriptions</h2>
            <p>Our services are offered on a subscription basis. By subscribing, you agree to the pricing and payment terms listed on our website.</p>
            
            <ul>
                <li><strong>Subscription Plans:</strong> Monthly ($19.99), Yearly ($199), Lifetime ($399).</li>
                <li><strong>Payment:</strong> Payment for services is processed through secure third-party payment processors. You agree to provide accurate payment details and authorize us to charge the applicable fees to your payment method.</li>
                <li><strong>Non-Payment:</strong> If you fail to make payment, your access to certain services, including the snippet generator, will be suspended.</li>
            </ul>
        </section>

        <section class="terms-section">
            <h2>4. User Responsibilities</h2>
            <p>You are responsible for:</p>
            
            <ul>
                <li>Ensuring your website complies with all applicable accessibility standards.</li>
                <li>Using the services only for lawful purposes and in compliance with applicable laws.</li>
                <li>Maintaining the confidentiality of your account login information.</li>
            </ul>
        </section>

        <section class="terms-section">
            <h2>5. License and Restrictions</h2>
            <p>We grant you a non-exclusive, non-transferable license to use our services for their intended purpose. You agree not to:</p>
            
            <ul>
                <li>Reverse engineer, decompile, or attempt to access the source code of our services.</li>
                <li>Use our services for any unlawful purpose or in a manner that violates the rights of others.</li>
            </ul>
        </section>

        <section class="terms-section">
            <h2>6. Termination</h2>
            <p>We may suspend or terminate your access to our services if you violate these Terms. You may cancel your subscription at any time through your account settings.</p>
        </section>

        <section class="terms-section">
            <h2>7. Disclaimers</h2>
            <ul>
                <li><strong>No Warranty:</strong> Our services are provided "as is" without warranties of any kind, either express or implied. We do not guarantee that your website will be fully compliant after using our tools or services.</li>
                <li><strong>Limitation of Liability:</strong> We are not liable for any damages or losses arising from the use of our website or services, including, but not limited to, legal claims, business disruptions, or financial losses.</li>
            </ul>
        </section>

        <section class="terms-section">
            <h2>8. Indemnification</h2>
            <p>You agree to indemnify and hold Ranzo Tech LLC harmless from any claims, damages, or liabilities arising out of your use of our services, violation of these Terms, or infringement of third-party rights.</p>
        </section>

        <section class="terms-section">
            <h2>9. Changes to the Terms</h2>
            <p>We reserve the right to update or modify these Terms at any time. Any changes will be posted on this page with an updated "Effective Date." By continuing to use our services, you agree to the revised Terms.</p>
        </section>

        <section class="terms-section">
            <h2>10. Governing Law</h2>
            <p>These Terms are governed by the laws of the state of Wyoming, without regard to its conflict of law principles. Any disputes will be resolved in the courts located in Sheridan, WY.</p>
        </section>

        <section class="terms-section contact-section">
            <h2>Contact Information</h2>
            <p>If you have any questions about these Terms of Service, please contact us:</p>
            <ul>
                <li><strong>Company:</strong> Ranzo Tech LLC</li>
                <li><strong>Email:</strong> support@adawizard.com</li>
                <li><strong>Address:</strong> Sheridan, WY</li>
            </ul>
        </section>

        <div class="terms-actions">
            <a href="dashboard.php" class="button">Back to Dashboard</a>
            <a href="register.php" class="button secondary">Create Account</a>
        </div>
    </div>
</div>

<style>
.terms-container {
    max-width: 800px;
    margin: 0 auto;
    padding: 20px;
    background: #fff;
    border-radius: 8px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    margin-top: 20px;
    margin-bottom: 40px;
}

.terms-content h1 {
    color: #2c3e50;
    text-align: center;
    margin-bottom: 10px;
    font-size: 2.5em;
}

.effective-date {
    text-align: center;
    color: #7f8c8d;
    margin-bottom: 30px;
    font-size: 1.1em;
}

.terms-section {
    margin-bottom: 30px;
    padding-bottom: 20px;
    border-bottom: 1px solid #ecf0f1;
}

.terms-section:last-of-type {
    border-bottom: none;
}

.terms-section h2 {
    color: #34495e;
    margin-bottom: 15px;
    font-size: 1.5em;
    border-left: 4px solid #3498db;
    padding-left: 15px;
}

.terms-section p {
    line-height: 1.6;
    margin-bottom: 15px;
    color: #2c3e50;
}

.terms-section ul {
    margin-left: 20px;
    margin-bottom: 15px;
}

.terms-section li {
    margin-bottom: 8px;
    line-height: 1.6;
    color: #2c3e50;
}

.contact-section {
    background: #f8f9fa;
    padding: 20px;
    border-radius: 6px;
    border: 1px solid #e9ecef;
}

.terms-actions {
    text-align: center;
    margin-top: 40px;
    padding-top: 20px;
    border-top: 2px solid #ecf0f1;
}

.terms-actions .button {
    margin: 0 10px;
    padding: 12px 24px;
    text-decoration: none;
    border-radius: 6px;
    display: inline-block;
    font-weight: 500;
    transition: background-color 0.3s ease;
}

.terms-actions .button:not(.secondary) {
    background-color: #3498db;
    color: white;
}

.terms-actions .button:not(.secondary):hover {
    background-color: #2980b9;
}

.terms-actions .button.secondary {
    background-color: #95a5a6;
    color: white;
}

.terms-actions .button.secondary:hover {
    background-color: #7f8c8d;
}

@media (max-width: 768px) {
    .terms-container {
        margin: 10px;
        padding: 15px;
    }
    
    .terms-content h1 {
        font-size: 2em;
    }
    
    .terms-section h2 {
        font-size: 1.3em;
    }
    
    .terms-actions .button {
        display: block;
        margin: 10px auto;
        width: 200px;
    }
}
</style>

<?php
require_once __DIR__ . '/../includes/footer.php';
?>