</main> <!-- Close main.container -->

<footer class="footer">
    <div class="footer-top">
        <div class="footer-content">
            <div class="footer-section company-info">
                <div class="footer-logo">
                    <h3>ADA Wizard</h3>
                    <div class="logo-icon">
                        <svg width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M9 12l2 2 4-4"/>
                            <circle cx="12" cy="12" r="9"/>
                        </svg>
                    </div>
                </div>
                <p class="footer-tagline">Making the web accessible for everyone.</p>
                <p class="footer-description">Professional ADA compliance solutions to protect your business and make your website accessible to all users.</p>
                
                <!--<div class="footer-social">
                    <h4>Follow Us</h4>
                    <div class="social-links">
                        <a href="#" aria-label="Facebook" class="social-link">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/>
                            </svg>
                        </a>
                        <a href="#" aria-label="Twitter" class="social-link">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M23.953 4.57a10 10 0 01-2.825.775 4.958 4.958 0 002.163-2.723c-.951.555-2.005.959-3.127 1.184a4.92 4.92 0 00-8.384 4.482C7.69 8.095 4.067 6.13 1.64 3.162a4.822 4.822 0 00-.666 2.475c0 1.71.87 3.213 2.188 4.096a4.904 4.904 0 01-2.228-.616v.06a4.923 4.923 0 003.946 4.827 4.996 4.996 0 01-2.212.085 4.936 4.936 0 004.604 3.417 9.867 9.867 0 01-6.102 2.105c-.39 0-.779-.023-1.17-.067a13.995 13.995 0 007.557 2.209c9.053 0 13.998-7.496 13.998-13.985 0-.21 0-.42-.015-.63A9.935 9.935 0 0024 4.59z"/>
                            </svg>
                        </a>
                        <a href="#" aria-label="LinkedIn" class="social-link">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M20.447 20.452h-3.554v-5.569c0-1.328-.027-3.037-1.852-3.037-1.853 0-2.136 1.445-2.136 2.939v5.667H9.351V9h3.414v1.561h.046c.477-.9 1.637-1.85 3.37-1.85 3.601 0 4.267 2.37 4.267 5.455v6.286zM5.337 7.433c-1.144 0-2.063-.926-2.063-2.065 0-1.138.92-2.063 2.063-2.063 1.14 0 2.064.925 2.064 2.063 0 1.139-.925 2.065-2.064 2.065zm1.782 13.019H3.555V9h3.564v11.452zM22.225 0H1.771C.792 0 0 .774 0 1.729v20.542C0 23.227.792 24 1.771 24h20.451C23.2 24 24 23.227 24 22.271V1.729C24 .774 23.2 0 22.222 0h.003z"/>
                            </svg>
                        </a>
                    </div>
                </div>-->
            </div>
            
            <div class="footer-section">
                <h4>Quick Links</h4>
                <ul class="footer-links">
                    <li><a href="dashboard.php">Dashboard</a></li>
                    <li><a href="compliance-checker.php">Compliance Checker</a></li>
                    <li><a href="aboutus.php">About Us</a></li>
                    <li><a href="home.php">Website Audit</a></li>
                    <li><a href="register.php">Get Started</a></li>
                </ul>
            </div>
            
            <div class="footer-section">
                <h4>Services</h4>
                <ul class="footer-links">
                    <li><a href="compliance-checker.php">ADA Compliance Check</a></li>
                    <li><a href="register.php">Accessibility Widget</a></li>
                    <li><a href="register.php">Monthly Plans</a></li>
                    <li><a href="register.php">Lifetime Access</a></li>
                    <li><a href="aboutus.php">Expert Support</a></li>
                </ul>
            </div>
            
            <div class="footer-section">
                <h4>Legal & Support</h4>
                <ul class="footer-links">
                    <li><a href="termsofservice.php">Terms of Service</a></li>
                    <li><a href="termsofservice.php">Privacy Policy</a></li>
                    <li><a href="aboutus.php#contact">Contact Us</a></li>
                    <li><a href="aboutus.php">Help Center</a></li>
                    <li><a href="aboutus.php">Documentation</a></li>
                </ul>
            </div>
            
            <div class="footer-section contact-info">
                <h4>Contact Information</h4>
                <div class="contact-details">
                    <div class="contact-item">
                        <div class="contact-icon">
                            <svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <path d="M21 10c0 7-9 13-9 13s-9-6-9-13a9 9 0 0 1 18 0z"/>
                                <circle cx="12" cy="10" r="3"/>
                            </svg>
                        </div>
                        <div class="contact-text">
                            <strong>Ranzo Tech LLC</strong><br>
                            Sheridan, Wyoming, USA
                        </div>
                    </div>
                    
                    <div class="contact-item">
                        <div class="contact-icon">
                            <svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <path d="M4 4h16c1.1 0 2 .9 2 2v12c0 1.1-.9 2-2 2H4c-1.1 0-2-.9-2-2V6c0-1.1.9-2 2-2z"/>
                                <polyline points="22,6 12,13 2,6"/>
                            </svg>
                        </div>
                        <div class="contact-text">
                            <a href="mailto:support@adawizard.com">support@adawizard.com</a>
                        </div>
                    </div>
                    
                   <!-- <div class="contact-item">
                        <div class="contact-icon">
                            <svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <path d="M22 16.92v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07 19.5 19.5 0 0 1-6-6 19.79 19.79 0 0 1-3.07-8.67A2 2 0 0 1 4.11 2h3a2 2 0 0 1 2 1.72 12.84 12.84 0 0 0 .7 2.81 2 2 0 0 1-.45 2.11L8.09 9.91a16 16 0 0 0 6 6l1.27-1.27a2 2 0 0 1 2.11-.45 12.84 12.84 0 0 0 2.81.7A2 2 0 0 1 22 16.92z"/>
                            </svg>
                        </div>
                        <div class="contact-text">
                        </div>
                    </div>-->
                </div>
                
                <div class="footer-cta">
                    <p>Need help with ADA compliance?</p>
                    <a href="register.php" class="footer-cta-button">Get Started Today</a>
                </div>
            </div>
        </div>
    </div>
    
    <div class="footer-bottom">
        <div class="footer-bottom-content">
            <div class="footer-bottom-left">
                <p>&copy; 2025 Ranzo Tech LLC. All rights reserved.</p>
                <p class="footer-compliance">ADA compliant website by ADA Wizard</p>
            </div>
            <div class="footer-bottom-right">
                <div class="footer-badges">
                    <span class="badge">🔒 Secure</span>
                    <span class="badge">✓ ADA Compliant</span>
                    <span class="badge">⚡ Fast</span>
                </div>
            </div>
        </div>
    </div>
</footer>

<style>
/* Modern Footer Styles */
.footer {
    background: linear-gradient(135deg, #2c3e50 0%, #34495e 100%);
    color: #ecf0f1;
    margin-top: 0;
    position: relative;
}

.footer::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 1px;
    background: linear-gradient(90deg, transparent, #3498db, transparent);
}

.footer-top {
    padding: 60px 0 40px;
}

.footer-content {
    max-width: 1400px;
    margin: 0 auto;
    padding: 0 40px;
    display: grid;
    grid-template-columns: 1.5fr 1fr 1fr 1fr 1.2fr;
    gap: 40px;
}

.footer-section h4 {
    color: #3498db;
    font-size: 1.2em;
    margin-bottom: 20px;
    font-weight: 600;
    position: relative;
}

.footer-section h4::after {
    content: '';
    position: absolute;
    bottom: -8px;
    left: 0;
    width: 30px;
    height: 2px;
    background: #3498db;
    border-radius: 2px;
}

/* Company Info Section */
.company-info .footer-logo {
    display: flex;
    align-items: center;
    gap: 12px;
    margin-bottom: 15px;
}

.footer-logo h3 {
    color: #ecf0f1;
    font-size: 1.8em;
    margin: 0;
    font-weight: 700;
}

.logo-icon {
    background: #3498db;
    padding: 8px;
    border-radius: 8px;
    color: white;
}

.footer-tagline {
    font-size: 1.1em;
    color: #3498db;
    margin-bottom: 10px;
    font-weight: 500;
}

.footer-description {
    color: #bdc3c7;
    line-height: 1.6;
    margin-bottom: 25px;
}

/* Social Links */
.footer-social h4 {
    font-size: 1em;
    margin-bottom: 15px;
}

.social-links {
    display: flex;
    gap: 15px;
}

.social-link {
    display: flex;
    align-items: center;
    justify-content: center;
    width: 40px;
    height: 40px;
    background: rgba(52, 152, 219, 0.1);
    border: 1px solid rgba(52, 152, 219, 0.3);
    border-radius: 8px;
    color: #3498db;
    transition: all 0.3s ease;
}

.social-link:hover {
    background: #3498db;
    color: white;
    transform: translateY(-2px);
}

/* Footer Links */
.footer-links {
    list-style: none;
    padding: 0;
    margin: 0;
}

.footer-links li {
    margin-bottom: 12px;
}

.footer-links a {
    color: #bdc3c7;
    text-decoration: none;
    transition: all 0.3s ease;
    display: inline-block;
    position: relative;
}

.footer-links a:hover {
    color: #3498db;
    transform: translateX(5px);
}

.footer-links a::before {
    content: '→';
    position: absolute;
    left: -20px;
    opacity: 0;
    transition: opacity 0.3s ease;
    color: #3498db;
}

.footer-links a:hover::before {
    opacity: 1;
}

/* Contact Info */
.contact-details {
    margin-bottom: 25px;
}

.contact-item {
    display: flex;
    align-items: flex-start;
    gap: 12px;
    margin-bottom: 15px;
}

.contact-icon {
    color: #3498db;
    margin-top: 2px;
}

.contact-text {
    color: #bdc3c7;
    line-height: 1.5;
}

.contact-text a {
    color: #3498db;
    text-decoration: none;
}

.contact-text a:hover {
    text-decoration: underline;
}

.contact-text strong {
    color: #ecf0f1;
}

/* Footer CTA */
.footer-cta {
    background: rgba(52, 152, 219, 0.1);
    padding: 20px;
    border-radius: 8px;
    border: 1px solid rgba(52, 152, 219, 0.3);
    text-align: center;
}

.footer-cta p {
    margin-bottom: 15px;
    color: #ecf0f1;
    font-weight: 500;
}

.footer-cta-button {
    background: #3498db;
    color: white;
    padding: 10px 20px;
    border-radius: 6px;
    text-decoration: none;
    font-weight: 600;
    transition: all 0.3s ease;
    display: inline-block;
}

.footer-cta-button:hover {
    background: #2980b9;
    transform: translateY(-2px);
}

/* Footer Bottom */
.footer-bottom {
    background: rgba(0, 0, 0, 0.2);
    padding: 25px 0;
    border-top: 1px solid rgba(255, 255, 255, 0.1);
}

.footer-bottom-content {
    max-width: 1400px;
    margin: 0 auto;
    padding: 0 40px;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.footer-bottom-left p {
    margin: 0 0 5px 0;
    color: #bdc3c7;
}

.footer-compliance {
    font-size: 0.9em;
    color: #3498db !important;
    font-weight: 500;
}

.footer-badges {
    display: flex;
    gap: 15px;
}

.badge {
    background: rgba(52, 152, 219, 0.1);
    border: 1px solid rgba(52, 152, 219, 0.3);
    padding: 5px 12px;
    border-radius: 15px;
    font-size: 0.85em;
    color: #3498db;
    font-weight: 500;
}

/* Responsive Design */
@media (max-width: 1200px) {
    .footer-content {
        grid-template-columns: 1.5fr 1fr 1fr 1.2fr;
        padding: 0 30px;
    }
    
    .footer-section:nth-child(3) {
        display: none;
    }
}

@media (max-width: 968px) {
    .footer-content {
        grid-template-columns: 1fr 1fr;
        gap: 30px;
        padding: 0 25px;
    }
    
    .company-info {
        grid-column: 1 / -1;
    }
    
    .footer-bottom-content {
        flex-direction: column;
        gap: 15px;
        text-align: center;
        padding: 0 25px;
    }
}

@media (max-width: 768px) {
    .footer-content {
        grid-template-columns: 1fr;
        gap: 25px;
        padding: 0 20px;
    }
    
    .footer-top {
        padding: 40px 0 30px;
    }
    
    .footer-badges {
        flex-wrap: wrap;
        justify-content: center;
    }
    
    .social-links {
        justify-content: center;
    }
    
    .footer-bottom-content {
        padding: 0 20px;
    }
}

@media (max-width: 480px) {
    .footer-logo {
        flex-direction: column;
        text-align: center;
        gap: 8px;
    }
    
    .footer-logo h3 {
        font-size: 1.5em;
    }
    
    .footer-badges {
        flex-direction: column;
        align-items: center;
        gap: 8px;
    }
    
    .contact-item {
        flex-direction: column;
        text-align: center;
        gap: 5px;
    }
}
</style>

<?php
// In a real application, you might include JS files here
// For example: <script src="js/main.js"></script>
?>
</body>
</html>
