<?php
require_once __DIR__ . '/../includes/header.php';
?>

<div class="about-container">
    <div class="about-hero">
        <div class="hero-content">
            <h1>About Us</h1>
            <p class="hero-subtitle">Making the digital world accessible to everyone</p>
        </div>
    </div>

    <div class="about-content">
        <section class="mission-section">
            <div class="section-content">
                <h2>Our Mission</h2>
                <p>At Ranzo Tech LLC, we are dedicated to making the digital world accessible to everyone. Our mission is to help businesses achieve ADA compliance with affordable, easy-to-implement solutions that ensure equal access for all users, regardless of ability.</p>
                
                <p>With our innovative tools and expert support, we empower companies to enhance their online presence while avoiding legal risks and promoting inclusivity. Let us help you take the first step toward a more accessible future today!</p>
            </div>
        </section>

        <section class="values-section">
            <h2>Our Values</h2>
            <div class="values-grid">
                <div class="value-card">
                    <div class="value-icon">
                        <svg width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M9 12l2 2 4-4"/>
                            <circle cx="12" cy="12" r="9"/>
                        </svg>
                    </div>
                    <h3>Accessibility First</h3>
                    <p>We believe that digital accessibility is not optional—it's a fundamental right that should be available to everyone.</p>
                </div>

                <div class="value-card">
                    <div class="value-icon">
                        <svg width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M12 2L2 7l10 5 10-5-10-5z"/>
                            <path d="M2 17l10 5 10-5"/>
                            <path d="M2 12l10 5 10-5"/>
                        </svg>
                    </div>
                    <h3>Innovation</h3>
                    <p>We continuously develop cutting-edge tools and solutions to make ADA compliance easier and more effective.</p>
                </div>

                <div class="value-card">
                    <div class="value-icon">
                        <svg width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <circle cx="12" cy="12" r="3"/>
                            <path d="M19.4 15a1.65 1.65 0 0 0 .33 1.82l.06.06a2 2 0 0 1 0 2.83 2 2 0 0 1-2.83 0l-.06-.06a1.65 1.65 0 0 0-1.82-.33 1.65 1.65 0 0 0-1 1.51V21a2 2 0 0 1-2 2 2 2 0 0 1-2-2v-.09A1.65 1.65 0 0 0 9 19.4a1.65 1.65 0 0 0-1.82.33l-.06.06a2 2 0 0 1-2.83 0 2 2 0 0 1 0-2.83l.06-.06a1.65 1.65 0 0 0 .33-1.82 1.65 1.65 0 0 0-1.51-1H3a2 2 0 0 1-2-2 2 2 0 0 1 2-2h.09A1.65 1.65 0 0 0 4.6 9a1.65 1.65 0 0 0-.33-1.82l-.06-.06a2 2 0 0 1 0-2.83 2 2 0 0 1 2.83 0l.06.06a1.65 1.65 0 0 0 1.82.33H9a1.65 1.65 0 0 0 1 1.51V3a2 2 0 0 1 2-2 2 2 0 0 1 2 2v.09a1.65 1.65 0 0 0 1 1.51 1.65 1.65 0 0 0 1.82-.33l.06-.06a2 2 0 0 1 2.83 0 2 2 0 0 1 0 2.83l-.06.06a1.65 1.65 0 0 0-.33 1.82V9a1.65 1.65 0 0 0 1.51 1H21a2 2 0 0 1 2 2 2 2 0 0 1-2 2h-.09a1.65 1.65 0 0 0-1.51 1z"/>
                        </svg>
                    </div>
                    <h3>Simplicity</h3>
                    <p>We make complex ADA compliance requirements simple to understand and implement for businesses of all sizes.</p>
                </div>

                <div class="value-card">
                    <div class="value-icon">
                        <svg width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"/>
                            <circle cx="9" cy="7" r="4"/>
                            <path d="M23 21v-2a4 4 0 0 0-3-3.87"/>
                            <path d="M16 3.13a4 4 0 0 1 0 7.75"/>
                        </svg>
                    </div>
                    <h3>Support</h3>
                    <p>Our dedicated team provides expert guidance and support throughout your accessibility compliance journey.</p>
                </div>
            </div>
        </section>

        <section class="services-section">
            <h2>What We Offer</h2>
            <div class="services-grid">
                <div class="service-item">
                    <h3>ADA Compliance Audits</h3>
                    <p>Comprehensive website assessments to identify accessibility issues and provide actionable recommendations.</p>
                </div>
                <div class="service-item">
                    <h3>Accessibility Widget</h3>
                    <p>Easy-to-implement widget that instantly improves your website's accessibility features for users with disabilities.</p>
                </div>
                <div class="service-item">
                    <h3>Expert Consultation</h3>
                    <p>Professional guidance from accessibility experts to help you navigate ADA requirements and best practices.</p>
                </div>
                <div class="service-item">
                    <h3>Ongoing Monitoring</h3>
                    <p>Continuous monitoring and updates to ensure your website maintains compliance as standards evolve.</p>
                </div>
            </div>
        </section>

        <section class="why-choose-section">
            <div class="section-content">
                <h2>Why Choose ADA Wizard?</h2>
                <div class="benefits-list">
                    <div class="benefit-item">
                        <strong>Affordable Solutions:</strong> We offer cost-effective plans that fit any budget, from startups to enterprises.
                    </div>
                    <div class="benefit-item">
                        <strong>Quick Implementation:</strong> Get your accessibility widget up and running in minutes, not months.
                    </div>
                    <div class="benefit-item">
                        <strong>Legal Protection:</strong> Reduce your risk of ADA-related lawsuits with our comprehensive compliance tools.
                    </div>
                    <div class="benefit-item">
                        <strong>Inclusive Design:</strong> Help create a more inclusive web that welcomes all users, regardless of their abilities.
                    </div>
                </div>
            </div>
        </section>

        <section class="cta-section">
            <div class="cta-content">
                <h2>Ready to Make Your Website Accessible?</h2>
                <p>Join thousands of businesses that trust ADA Wizard to keep their websites compliant and inclusive.</p>
                <div class="cta-buttons">
                    <a href="register.php" class="button primary">Get Started Today</a>
                    <a href="dashboard.php" class="button secondary">View Dashboard</a>
                </div>
            </div>
        </section>

        <section class="contact-section">
            <h2>Contact Us</h2>
            <div class="contact-info">
                <div class="contact-item">
                    <strong>Company:</strong> Ranzo Tech LLC
                </div>
                <div class="contact-item">
                    <strong>Location:</strong> Sheridan, Wyoming
                </div>
                <div class="contact-item">
                    <strong>Email:</strong> <a href="mailto:support@adawizard.com">support@adawizard.com</a>
                </div>
            </div>
        </section>
    </div>
</div>

<style>
.about-container {
    max-width: 1200px;
    margin: 0 auto;
    background: #fff;
}

.about-hero {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    text-align: center;
    padding: 80px 20px;
    margin-bottom: 0;
}

.hero-content h1 {
    font-size: 3.5em;
    margin-bottom: 20px;
    font-weight: 300;
}

.hero-subtitle {
    font-size: 1.3em;
    opacity: 0.9;
    max-width: 600px;
    margin: 0 auto;
}

.about-content {
    padding: 0 20px 40px;
}

.mission-section,
.why-choose-section {
    background: #f8f9fa;
    padding: 60px 40px;
    margin: 40px -20px;
    border-radius: 8px;
}

.section-content {
    max-width: 800px;
    margin: 0 auto;
    text-align: center;
}

.section-content h2 {
    color: #2c3e50;
    font-size: 2.5em;
    margin-bottom: 30px;
}

.section-content p {
    font-size: 1.2em;
    line-height: 1.8;
    color: #34495e;
    margin-bottom: 20px;
}

.values-section,
.services-section {
    padding: 60px 20px;
    text-align: center;
}

.values-section h2,
.services-section h2 {
    color: #2c3e50;
    font-size: 2.5em;
    margin-bottom: 50px;
}

.values-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 40px;
    max-width: 1000px;
    margin: 0 auto;
}

.value-card {
    padding: 30px 20px;
    border-radius: 10px;
    box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    transition: transform 0.3s ease;
}

.value-card:hover {
    transform: translateY(-5px);
}

.value-icon {
    color: #3498db;
    margin-bottom: 20px;
}

.value-card h3 {
    color: #2c3e50;
    font-size: 1.5em;
    margin-bottom: 15px;
}

.value-card p {
    color: #7f8c8d;
    line-height: 1.6;
}

.services-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
    gap: 30px;
    max-width: 1000px;
    margin: 0 auto;
}

.service-item {
    background: #fff;
    padding: 30px;
    border-radius: 8px;
    box-shadow: 0 3px 10px rgba(0,0,0,0.1);
    border-left: 4px solid #3498db;
}

.service-item h3 {
    color: #2c3e50;
    font-size: 1.4em;
    margin-bottom: 15px;
}

.service-item p {
    color: #7f8c8d;
    line-height: 1.6;
}

.benefits-list {
    text-align: left;
    max-width: 600px;
    margin: 0 auto;
}

.benefit-item {
    background: white;
    padding: 20px;
    margin-bottom: 15px;
    border-radius: 8px;
    border-left: 4px solid #27ae60;
    box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    font-size: 1.1em;
    line-height: 1.6;
    color: #2c3e50;
}

.cta-section {
    background: linear-gradient(135deg, #3498db 0%, #2980b9 100%);
    color: white;
    text-align: center;
    padding: 80px 40px;
    margin: 60px -20px 40px;
    border-radius: 8px;
}

.cta-content h2 {
    font-size: 2.5em;
    margin-bottom: 20px;
    font-weight: 300;
}

.cta-content p {
    font-size: 1.2em;
    margin-bottom: 40px;
    opacity: 0.9;
}

.cta-buttons {
    display: flex;
    gap: 20px;
    justify-content: center;
    flex-wrap: wrap;
}

.cta-buttons .button {
    padding: 15px 30px;
    font-size: 1.1em;
    font-weight: 500;
    text-decoration: none;
    border-radius: 6px;
    transition: all 0.3s ease;
    min-width: 180px;
}

.cta-buttons .button.primary {
    background: white;
    color: #3498db;
}

.cta-buttons .button.primary:hover {
    background: #f8f9fa;
}

.cta-buttons .button.secondary {
    background: transparent;
    color: white;
    border: 2px solid white;
}

.cta-buttons .button.secondary:hover {
    background: white;
    color: #3498db;
}

.contact-section {
    text-align: center;
    padding: 40px 20px;
}

.contact-section h2 {
    color: #2c3e50;
    font-size: 2em;
    margin-bottom: 30px;
}

.contact-info {
    max-width: 400px;
    margin: 0 auto;
}

.contact-item {
    background: #f8f9fa;
    padding: 15px 20px;
    margin-bottom: 10px;
    border-radius: 6px;
    font-size: 1.1em;
    color: #2c3e50;
}

.contact-item a {
    color: #3498db;
    text-decoration: none;
}

.contact-item a:hover {
    text-decoration: underline;
}

@media (max-width: 768px) {
    .about-hero {
        padding: 60px 20px;
    }
    
    .hero-content h1 {
        font-size: 2.5em;
    }
    
    .hero-subtitle {
        font-size: 1.1em;
    }
    
    .mission-section,
    .why-choose-section,
    .cta-section {
        padding: 40px 20px;
        margin-left: -20px;
        margin-right: -20px;
    }
    
    .section-content h2,
    .values-section h2,
    .services-section h2 {
        font-size: 2em;
    }
    
    .values-grid {
        grid-template-columns: 1fr;
        gap: 30px;
    }
    
    .services-grid {
        grid-template-columns: 1fr;
    }
    
    .cta-buttons {
        flex-direction: column;
        align-items: center;
    }
    
    .cta-buttons .button {
        width: 100%;
        max-width: 250px;
    }
}
</style>

<?php
require_once __DIR__ . '/../includes/footer.php';
?>